package gui;

import javax.swing.BorderFactory;
import javax.swing.border.*;
import java.awt.Color;
import java.awt.Font;
import gui.jtransitionsystem.JTransitionSystemSimple;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import service.*;

import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.SwingConstants;
import javax.swing.JButton;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import java.util.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;


/**
 * @author Andrea
 *
 */
public class SimulationPanel extends JPanel
{
	static final long serialVersionUID = 1L;
	//private JLabel titolo = null;
	private JScrollPane listScroller = null;
	private JTable actionList = null;
	private JLabel actionLabel = null;  
	private JButton actionButton = null;
	private JPanel buttonPanel = null;
	private JButton startSimulation = null;
	private JButton stopSimulation = null;
	
	private Vector<SimpleTransition> availableActions = null;
	private Vector<String> actionNames = null;
	
	public SimulationPanel()
	{
		super();
		initialize();
	}
	
	void initialize()
	{
		this.setLayout(new BorderLayout());
		/**
		 * adding title to the panel
		 */
		//titolo = new JLabel();
		//titolo.setText("Action Panel");
		//titolo.setHorizontalAlignment(SwingConstants.CENTER);
		//this.add(titolo, BorderLayout.NORTH);
		
		actionList = getActionList();
		
		/**
		 * adding the list to the JScrollerPane
		 */
		
		listScroller = new JScrollPane(actionList);
		listScroller.setPreferredSize(new Dimension(100,100));

		this.add(listScroller, BorderLayout.CENTER);
		this.add(getActionLabel(), BorderLayout.WEST);
		/**
		 * adding the doAction Button
		 */
		buttonPanel = new JPanel();
		buttonPanel.add(getActionButton());
		buttonPanel.add(getStartSimulation());
		buttonPanel.add(getStopSimulation());
		this.add(buttonPanel, BorderLayout.SOUTH);
		this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.RED, 1), "Simulation Panel", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, new Font("Arial", Font.BOLD, 14), Color.red));
	}

	/**
	 * This method initializes actionLabel	
	 * 	
	 * @return javax.swing.JLabel	
	 */
	private JLabel getActionLabel() {
		if (actionLabel == null) {
			actionLabel = new JLabel();
			actionLabel.setText("Available Actions:");
			actionLabel.setVerticalTextPosition(SwingConstants.TOP);
			actionLabel.setVerticalAlignment(SwingConstants.TOP);
		}
		return actionLabel;
	}
	
	public JButton getActionButton()
	{
		if(actionButton == null)
		{
			actionButton = new JButton();
			actionButton.setText("Do Action");
			actionButton.addActionListener(new ActionListener()
			{
				public void actionPerformed(ActionEvent e)
				{
					
					if(actionList.getSelectedRow()==-1)
					{}
					else
					{
						int index = actionList.getSelectedRow();
						try
						{
							GenericLoader.doAction(availableActions.elementAt(index));
							JTransitionSystemSimple jt = GenericLoader.getJTargetService();
							GraphViewerPanel graphPanel = MainFrame.getInstance().getGraphViewerPanel();
							
							graphPanel.printGraph(jt.getVisualizationViewer());
							graphPanel.setGraphName(GenericLoader.getTargetServiceName());
							
							initActionList();
							/**
							 * the above instruction updates the list of the actions
							 */
							
							/**
							 * in the following:
							 * 		- updates available services current states in within the JTable
							 * 		- shows which of the available services executes the action
							 * 		- inserts initial states into available services table
							 */
							
							JTable serviceList=MainFrame.getInstance().getAvServPanel().getAvailableServiceList();
							TableModel tableModel=serviceList.getModel();
							ComposedState composedState=GenericLoader.getCurrentAvailableState();
							for(int i=0;i<tableModel.getRowCount();i++){
								
								tableModel.setValueAt(composedState.getServicesState(i).getName(), i, 1);
							}
							TransitionSystem<SimpleState,SimpleTransition> lastTSExecutedAction=
								GenericLoader.getLastTSExecutedAction();
							
							JTable targetList=MainFrame.getInstance().getAvServPanel().getTargetServiceList();
							TableModel tableModel1=targetList.getModel();
							tableModel1.setValueAt(GenericLoader.getCurrentTargetState().getName(), 0, 1);

							
							JOptionPane.showMessageDialog(null, "Action executed by the service "+
																lastTSExecutedAction.getName());
						}
						catch(Exception ex)
						{
							JOptionPane.showMessageDialog(MainFrame.getInstance(), "State Description Panel error: \n"+ ex.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
						}
					}
					
				}
			}
			);
			actionButton.setEnabled(false);
		}
		return actionButton;
	}
	
	public JButton getStartSimulation()
	{
		if(startSimulation == null)
		{
			startSimulation = new JButton("Compute Simulation");
			startSimulation.addActionListener(new ActionListener()
			{
				public void actionPerformed(ActionEvent e)
				{
					try
					{
						
						GenericLoader.startOrchestrator();
						/**
						 * inserts initial states into the available services Table
						 */
						JTable serviceList=MainFrame.getInstance().getAvServPanel().getAvailableServiceList();
						TableModel tableModel=serviceList.getModel();
						ComposedState composedState=GenericLoader.getCurrentAvailableState();
						if(!GenericLoader.getCompositionTs().isValid())
						{
							JOptionPane.showMessageDialog(MainFrame.getInstance(), "Composition Transition System is not valid.\nNo any Initial State found.\nCannot go further with the Simulation.", "Error",JOptionPane.ERROR_MESSAGE);
							return;
						}
						for(int i=0;i<tableModel.getRowCount();i++){
							tableModel.setValueAt(composedState.getServicesState(i).getName(), i, 1);
						}
						
						JTable targetList=MainFrame.getInstance().getAvServPanel().getTargetServiceList();
						TableModel tableModel1=targetList.getModel();
						tableModel1.setValueAt(GenericLoader.getCurrentTargetState().getName(), 0, 1);


						JTransitionSystemSimple jt = GenericLoader.getJTargetService();
						GraphViewerPanel graphPanel = MainFrame.getInstance().getGraphViewerPanel();

						if(GenericLoader.getTargetService().getAllStates().size() >= 20 )
						{
							if(JOptionPane.showConfirmDialog(null, "Target System size is "+ GenericLoader.getTargetService().getAllStates().size()+ "nodes.\nVisualization could be very slow.\nDo you want to visualize it anyway?", "Warning", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE)== JOptionPane.YES_OPTION)
							{
								
								graphPanel.printGraph(jt.getVisualizationViewer());
								graphPanel.setGraphName(GenericLoader.getTargetServiceName());
								
							}
							
						}
						else
						{
							
							graphPanel.printGraph(jt.getVisualizationViewer());
							graphPanel.setGraphName(GenericLoader.getTargetServiceName());
							
						}
						MainFrame.getInstance().getStateDescriptionPanel().initActionList();
						MainFrame.getInstance().toFront();

					
						MainFrame.getInstance().getAvServPanel().getRemoveAvailableServiceButton().setEnabled(false);

					}
					catch(Exception exc)
					{
						JOptionPane.showMessageDialog(null,"Error: "+exc.getMessage(),"Error", JOptionPane.ERROR_MESSAGE);
					}
				}
				}
			
			);
			startSimulation.setEnabled(false);
		}
		return startSimulation;
	}
	
	public JButton getStopSimulation()
	{
		if(stopSimulation == null)
		{
			stopSimulation = new JButton("Stop Simulation");
			stopSimulation.addActionListener(new ActionListener()
			{
				public void actionPerformed(ActionEvent e)
				{
					try
					{
						GenericLoader.stopOrchestrator();
						//inserts initial states in the JTable
						JTable serviceList=MainFrame.getInstance().getAvServPanel().getAvailableServiceList();
						TableModel tableModel=serviceList.getModel();
						for(int i=0;i<tableModel.getRowCount();i++){
							
							tableModel.setValueAt("None", i, 1);
						}
						MainFrame.getInstance().getStateDescriptionPanel().resetActionList();
						//MainFrame.getInstance().getGraphViewerPanel().resetGraphPanel();
						
						MainFrame.getInstance().getAvServPanel().getRemoveAvailableServiceButton().setEnabled(true);
						MainFrame.getInstance().getAvServPanel().getActionButton().setEnabled(true);
						MainFrame.getInstance().getAvServPanel().getActionButton1().setEnabled(true);

					}
					catch(Exception exc)
					{
						JOptionPane.showMessageDialog(null, exc.getMessage(),"Error", JOptionPane.ERROR_MESSAGE);
						System.out.println(exc.getMessage());
					}
					
				}
				
			});
			stopSimulation.setEnabled(false);
		}
		return stopSimulation;
	}
	public void resetActionList(){
		if(actionList!=null){
			TableModel tableModel = 
				new DefaultTableModel(
						new String[][]{{}},
						new String[] { "Action Name", "Target State"});
			actionList.setModel(tableModel);
			actionList.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
			actionList.getColumnModel().getColumn(0).setPreferredWidth(150);
			actionList.getColumnModel().getColumn(1).setPreferredWidth(150);
			actionList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
			actionList.setColumnSelectionAllowed(false);
			actionList.setRowSelectionAllowed(true);

			updateUI();
		}
	}
	
	public void initActionList()
	{	
		if(availableActions == null) availableActions = new Vector<SimpleTransition>(0,1);
		if(actionNames == null) actionNames = new Vector<String>(0,1);
		availableActions.removeAllElements();
		actionNames.removeAllElements();
		try
		{
			SimpleState currentState = GenericLoader.getCurrentTargetState();
			Set<SimpleTransition> actions = GenericLoader.getTargetService().getActionsOf(currentState);
			Iterator<SimpleTransition> it = actions.iterator();

			String data[][]=new String[actions.size()][2];
			int i=0;
			while(it.hasNext())
			{
				SimpleTransition temp = it.next();
				availableActions.add(temp);
				actionNames.add(temp.getName());
				data[i][0]=temp.getName();
				data[i][1]=temp.getStateTo().getName();
				i++;
			}
			TableModel tableModel = 
				new DefaultTableModel(
						data,
						new String[] { "Action Name", "Target State"});
			actionList.setModel(tableModel);
			actionList.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
			actionList.getColumnModel().getColumn(0).setPreferredWidth(150);
			actionList.getColumnModel().getColumn(1).setPreferredWidth(150);
			actionList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
			actionList.setColumnSelectionAllowed(false);
			actionList.setRowSelectionAllowed(true);

			
		}
		catch(Exception ex)
		{
			JOptionPane.showMessageDialog(MainFrame.getInstance(), "Error: "+ex.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
		}
	}
	
	private JTable getActionList()
	{
		if(actionList == null)
		{
			actionList=new JTable();
			TableModel tableModel = 
				new DefaultTableModel(
						new String[][]{{}},
						new String[] { "Action Name", "Target State"});
			actionList.setModel(tableModel);
			actionList.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
			actionList.getColumnModel().getColumn(0).setPreferredWidth(150);
			actionList.getColumnModel().getColumn(1).setPreferredWidth(150);
			actionList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
			actionList.setColumnSelectionAllowed(false);
			actionList.setRowSelectionAllowed(true);
			
		}
		return actionList;
	}
}
